//============================================================================
// BASIC INTERFACE IMPLEMENTOR
//
// Desc: %DESC%
//
// Date: %DATE%			Auth: %AUTHOR%
//============================================================================
#ifndef __system_interface_basic_h
#define __system_interface_basic_h 1

//============================================================================
// DEPENDENCIES
//============================================================================
#include <interface.h>

BEGIN_SYSTEM_NAMESPACE

//============================================================================
// IMPLEMENTOR
//============================================================================
class Basic_Interface_Imp
{
protected:
  // Realized common Interface methods

private:
   // Non-realized Interface methods

  static int init(const System_Info *si);

private:
  // Interface common data members
};
  
//============================================================================
// SCENARIO ADAPTER
//============================================================================
template<class Interface_Imp>
class Interface_Adapter: public Interface_Imp
{
public:
  Interface_Adapter() {}
  ~Interface_Adapter() {}

//   const Type &method() const {
//     enter();
//     const Type &aux = Interface_Imp::method();
//     leave();
//     return tmp;
//   }

//   int method() {
//     enter();
//     int err = Interface_Imp::method();
//     leave();
//     return err;
//   }
};

//============================================================================
// LOI STUB
//============================================================================
BEGIN_LOI_NAMESPACE

template<class Interface_Imp>
class Interface_Stub: public Interface_Adapter<Interface_Imp> {};

END_LOI_NAMESPACE

//============================================================================
// ROI ADAPTER
//============================================================================
BEGIN_ROI_NAMESPACE

template<class Interface_Imp>
class Interface_Stub: public Controlled_Abstraction_ROI_Stub
{
// Valid Interface methods
enum {INTERFACE_CREATE = FIRST_INTERFACE_METHOD, INTERFACE_DESTROY, 
      LAST_INTERFACE_METHOD = INTERFACE_};

public:
  Interface_Stub()
    {invoke(INTERFACE_CREATE);}

  ~Interface_Stub()
    {invoke(INTERFACE_DESTROY);}

//   Type method() const {
//     invoke(INTERFACE_METHOD);
//     Type aux;
//     get_parm(aux);
//     return aux;
//   }

//   int method() const {return invoke(INTERFACE_METHOD);}
};

template<class Interface_Imp>
class Interface_Server: public Interface_Adapter<Interface_Imp>
{
private:
  static Interface_Adapter<Interface_Imp> *get_object(const Abstraction_Id &id)
    {return reinterpret_cast<Interface_Adapter<Interface_Imp> *>
       (Interface_Imp::get_object(id));}

public:
  static void create(Abstraction_Message *msg) {
    const Interface_Adapter<Interface_Imp> *obj =
      new (msg->get_id()) Interface_Adapter<Interface_Imp>;
    msg->set_id(obj->get_id());
  }

  static void destroy(Abstraction_Message *msg) {
    const Interface_Adapter<Interface_Imp> *obj = get_object(msg->get_id());
    delete obj;
  }

//   static void method(Abstraction_Message *msg) {
//     const Interface_Adapter<Interface_Imp> *obj = get_object(msg->get_id());
//     msg->set_parm(obj->get_nid());    
//   }

//   static void method(Abstraction_Message *msg) {
//     Interface_Adapter<Interface_Imp> *obj = get_object(msg->get_id());
//     msg->set_result(obj->reset());
//   }
};

END_ROI_NAMESPACE

//============================================================================
// HANDLE
//============================================================================
USING_CURRENT_INVOCATION_MODE;
template<class Interface_Imp>
class Interface_Handle
{
public:
  Interface_Handle(Abstraction_Unit unit = ANY_UNIT)
    {Abstraction_Id id(Interface_Imp::type, unit);
    stub = new (id) Interface_Stub<Interface_Imp>;}
  Interface_Handle(const Abstraction_Id &id)
    {stub = new (id) Interface_Stub<Interface_Imp>;}
  Interface_Handle(const Interface_Handle &object) 
    {stub = new (object.get_id()) Interface_Stub<Interface_Imp>;}
  ~Interface_Handle() {delete stub;}
    
  bool is_valid() const {return stub->is_valid();}

//   const Type &method() const {return stub->method();}

//   int method() const {return stub->method();}

private:
  Interface_Stub<Interface_Imp> *stub;
};

END_SYSTEM_NAMESPACE

#endif // __system_interface_basic_h




