// EPOS fileSystem Common Package
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#ifndef __filesystem_common_h
#define __filesystem_common_h

//#include <system/config_defs.h>

__BEGIN_SYS
__BEGIN_IMP

#ifndef DESCRIPTORS_NUMBER
#define DESCRIPTORS_NUMBER 512
#endif

#ifndef BLOCK_SIZE
#define BLOCK_SIZE 256
#endif

#ifndef ADDRESS_FOR_BLOCK
#define ADDRESS_FOR_BLOCK 256 //BLOCK_SIZE/sizeof(Address)
#endif

#ifndef OFTsize
#define OFTsize 50		// size of OpenFileTable
#endif

#define DirectoryType 0x00
#define LinkType 0x01
#define ContiguousType 0x02
#define INodeType 0x03


typedef enum {seekBegin, seekCur, seekEnd} SeekWhence;

typedef enum {contiguosFile, inodeFile} FileSystemType;

typedef unsigned int Address;

typedef enum {readOnly, readWrite, readWriteTruncate, directory} OpenMode;

#define copy(src, tgt, size) for (unsigned long i = 0; i < size; i++) \
                               ((char *)(tgt))[i] = ((char *)(src))[i]

typedef struct OFTEntry{
    int addressOfDescriptor;   
    int timesOpenned;   
    int writers;
		OFTEntry(int address, int times, int wr) : addressOfDescriptor(address), timesOpenned(times), writers(wr) {};
	  OFTEntry() : addressOfDescriptor(0), timesOpenned(0), writers(0) {};
 };

/**
 * FileDescriptor has 16 Bytes, 128 bits.
 */
typedef union {
    struct {
	      unsigned int TYPE; //DirectoryType, LinkType, ContiguousType, INodeType
	      unsigned int DATE;
	      unsigned int ADDRESS;
	      unsigned int SIZE;
    };    
    struct {
        FileSystemType fileSystemType;
		    unsigned char descriptorsForBitsMap;
		    unsigned short int numOfDescriptors;
        Address blocksStart; //where the data blocks starts, after descriptors.
    };    
} FileDescriptor;

#define DESCRIPTORS_FOR_BLOCK (BLOCK_SIZE/sizeof(FileDescriptor))


typedef struct {
    char fileName[252];
    Address numberOfDescriptor;
} DirectoryEntry; 

typedef union {
    DirectoryEntry file[4];  
    FileDescriptor descriptor[DESCRIPTORS_FOR_BLOCK];
    unsigned char byte[BLOCK_SIZE];
    Address freeBlock[ADDRESS_FOR_BLOCK];
} Block;

/*
class fileSystem_Common: public __INT(fileSystem_Common)
{
protected:
    fileSystem_Common() {}

public:
    // fileSystem common methods

private:
    // fileSystem common attributes
};
*/
__END_IMP
__END_SYS

#endif
