// EPOS ContiguousFile Declarations
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#ifndef __contiguousfile_h
#define __contiguousfile_h

#include <filesystem.h>
#include "file.h"
#include "common.h"
#include "filefactory.h"
#include "freespacemanager.h"

__BEGIN_SYS
__BEGIN_IMP

class ContiguousFile: public File
{
private:

	
protected:
    virtual Address getNextBlockAddress();
    virtual Address calculePhysicAddress(Address logicAddress);
    virtual void getNextBlock();
	  virtual ~ContiguousFile();
		virtual bool ensureCapacity(unsigned long);

public:
	
	  /**
	   * Create the file system with releasing all blocks and descriptor.
	   */
	  static bool initialize();
		
};

__END_IMP
__END_SYS

#endif
