// EPOS DescriptorsManager Declarations
//
// Author: laureano
// Documentation: $EPOS/doc/filesystem			Date: 28 Jun 2004

#ifndef __descriptorsmanager_h
#define __descriptorsmanager_h

#include <filesystem.h>
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

class DescriptorsManager: //public __INT(DescriptorsManager),
  protected fileSystem_Common
{
private:
    static DescriptorsManager* dm;

    DescriptorsManager();
    ~DescriptorsManager();

public:
    static DescriptorsManager* getDescriptorsManager();

    /**
     * Set all descriptors as free.
     */
    void setAllDescriptorsAsFree();

    /**
     * Get the object descriptor which has number equals to numberOfDescriptor.
     */
    FileDescriptor* getDescriptor(Address numberOfDescriptor);    
    
    /**
     * Get one new free descriptor for a new file.
     */   
    Address getFreeDescriptor();

    /**
     * Get the free descriptor indicated.
     */   
    FileDescriptor* getFreeDescriptor(Address index);

    /**
     * Save the descriptor.
     */  
    bool writeDescriptor(FileDescriptor* desc, Address numberOfDes);
    
    /**
     * Release the descriptor which will be free.
     */    
    void releaseDescriptor(Address numberOfDescriptor);
};

__END_IMP
__END_SYS

#endif
