// EPOS Directory Declarations
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#ifndef __directory_h
#define __directory_h

#include <filesystem.h>
//#include "string.h"
#include "common.h"
#include "file.h"
#include "freespacemanager.h"

#define FILE_NOT_FOUND -1
#define MAX_TAM_FILE_NAME 251

__BEGIN_SYS
__BEGIN_IMP


class Directory: public File
{
private:
		File* storage;
    
    /**
     * Remove file with index equals than parameter, realesing all of
     * its blocks.
     */
    bool removeFileOfIndex(int index);
  
    /**     
     * Search for file with descriptor equals the argument.
     * return the index of file in actual block. block is changed for the block
     * which contain the file. Returns FILE_NOT_FOUND if the file wasn't
     * founded.
     */    
    int indexOfFile(Address numberOfDescriptor);

protected:
    virtual void setDescriptor(FileDescriptor* fd);

public:
    Directory();
    virtual ~Directory();    
	  void getNextBlock();
    bool addFile(Address numberOfDescriptor, const char* name);
    bool removeFile(Address numberOfDescriptor);
    bool removeFile(char* name);	
    
    File* findPath(const char* path);


    /**
     * Get a file which belongs to directory called name.
     */
    File* getFile(const char* name);

	  /**
     * Search for file with name equals the argument.
     * @return the index of file in actual block. block is changed for the block
     * which contain the file.
     */  
    int indexOfFile(const char* name);
		
    virtual bool isDirectory();

		Address calculePhysicAddress(Address x);
		bool ensureCapacity(unsigned long x);
		Address getNextBlockAddress ();
		bool write(void*,unsigned long);
		unsigned long read(void*,unsigned long);

};

__END_IMP
__END_SYS

#endif
