// EPOS File Declarations
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#ifndef __file_h
#define __file_h

#include <filesystem.h>
#include "common.h"
#include "mediator.h"
#include "openfiletable.h"
#include "filefactory.h"
//#include "string.h"

__BEGIN_SYS
__BEGIN_IMP

class File: protected fileSystem_Common
{

private:
    FileDescriptor* descriptor;
protected:
    friend class FileFactory;

    virtual void setDescriptor(FileDescriptor* d) {
      descriptor = d;
    }
    Address descriptorAddress;
    Block* block;         //Current Block in use
    Address blockAddress; //Logic Address of block
    Address curByte;      //Current byte inside block
    Address curAddress;   // makes easier read and write logic -- not necessary (laureano)! You could use blockAddress + curByte.
    static OpenFileTable* table;
    bool opened;
    OpenMode openmode;
	
    /**
     * Translate a logic address into a physic address.
     */
   virtual Address calculePhysicAddress(Address logicAddress) = 0;
    
    /**
     * Called mainly by write, shall ensure the file has enough capacity
     * to contain <i>size</i> bytes. 
     * @return true if the file has the capacity to write "size" bytes or
     * false otherwise.
     */
    virtual bool ensureCapacity(unsigned long size) = 0;
	
    /**
     * Get the block addressed by a, if this isn´t the actual block.
     */
    void getBlock(Address a);
     
    /**
     * Get the next File's block, if the File is a ContiguosFile, for
     * example, the block returned would be blockAddress + ;
     */
    virtual void getNextBlock() = 0;


    virtual Address getNextBlockAddress() = 0;
		virtual FileDescriptor* getDescriptor();
     
public:
    static File* open(char* path, OpenMode mode);
	void close();
    virtual ~File();
    void setMode(OpenMode m);
    friend class Directory;
    static Directory* getRoot();
    bool seek(long offset, SeekWhence whence);
    bool write(void* buffer, const unsigned long size);
    unsigned long read(void* buffer, const unsigned long size);

    /**
     * Returns if the file is a directory or not.
     * (to avoid using the typeid() as it seems to ignore subclasses)
     */
    virtual bool isDirectory();
	void setOpened(bool o);
};

__END_IMP
__END_SYS

#endif
