// EPOS FileFactory Declarations
//
// Author: gabriel
// Documentation: $EPOS/doc/filesystem			Date: 25 Jun 2004

#ifndef __filefactory_h
#define __filefactory_h

#include <filesystem.h>
#include "common.h"
#include "file.h"

__BEGIN_SYS
__BEGIN_IMP

class File;

class FileFactory: protected fileSystem_Common
{
private:
    FileFactory();
    ~FileFactory();   
    FileSystemType fileSystemType;
    static FileFactory *filefactory; //<<Singleton>>


public:
    static FileFactory *getFileFactory();

    /** 
     * Refresh the informations about file system.
     */
    void refreshFileSystemInformation();
    
    
    File* getNewFile();
    File* getNewFile(FileDescriptor* des);
};

__END_IMP
__END_SYS

#endif
