// EPOS fileSystem Interface
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#ifndef __filesystem_h
#define __filesystem_h

//#include <system/config.h>

#define __BEGIN_SYS 
#define __END_SYS 
#define __BEGIN_INT 
#define __END_INT 
#define __BEGIN_IMP
#define __END_IMP
#define __DEF {}
#define __IMP(x) x
#define __SYS(x) x
#define __INT(x) Dummy


typedef int Id;

__BEGIN_SYS
__BEGIN_INT

class fileSystem_Common
{
protected:
    fileSystem_Common() {}

public:
    // fileSystem common types and constants
};
/*
class fileSystem: public fileSystem_Common
{
public:
    fileSystem() __DEF;
    fileSystem(char* path) __DEF;
    fileSystem(const Id & id) __DEF;
    fileSystem(const fileSystem & obj) __DEF;
    ~fileSystem() __DEF;

    const Id & id();
    bool valid();

};

class File: public virtual fileSystem_Common
{
public:
    File(const Id & id) __DEF;
    File(const File & obj) __DEF;

    const Id & id();
    bool valid();

    static File* open();
protected:
    File() __DEF;
};

class Directory: public virtual fileSystem_Common
{
public:
    Directory(const Id & id) __DEF;
    Directory(const Directory & obj) __DEF;

    const Id & id();
    bool valid();
protected:
    Directory() __DEF;
};

class Link: public fileSystem_Common//, public virtual Directory
{
public:
    Link(const Id & id) __DEF;
    Link(const Link & obj) __DEF;

    const Id & id();
    bool valid();
protected:
    Link() __DEF;
};

class FreeSpaceManager: public fileSystem_Common
{
public:
    FreeSpaceManager(const Id & id) __DEF;
    FreeSpaceManager(const FreeSpaceManager & obj) __DEF;

    const Id & id();
    bool valid();
protected:
    FreeSpaceManager() __DEF;
};

class ContiguousFile: public fileSystem_Common
{
public:
    ContiguousFile(const Id & id) __DEF;
    ContiguousFile(const ContiguousFile & obj) __DEF;

    const Id & id();
    bool valid();
	  static bool initialize();
protected:
    ContiguousFile() __DEF;
};

class INodeFile: public fileSystem_Common
{
public:
    INodeFile(const Id & id) __DEF;
    INodeFile(const INodeFile & obj) __DEF;

    const Id & id();
    bool valid();
protected:
    INodeFile() __DEF;
};

class Mediator
{
public:
    Mediator(const Id & id) __DEF;
    Mediator(const Mediator & obj) __DEF;

    const Id & id();
    bool valid();

};

class FileFactory
{
/*  
public:
    FileFactory(const Id & id) __DEF;
    FileFactory(const FileFactory & obj) __DEF;

    const Id & id();
    bool valid();

};

class OpenFileTable
{
public:
    const Id & id();

};

class DescriptorsManager
{
*  
public:
    DescriptorsManager(const Id & id) __DEF;
    DescriptorsManager(const DescriptorsManager & obj) __DEF;

    const Id & id();
    bool valid();

};

class FileSystemInformation
{
*  
public:
    FileSystemInformation(const Id & id) __DEF;
    FileSystemInformation(const FileSystemInformation & obj) __DEF;

    Const Id & id();
    bool valid();

};
*/

__END_INT
__END_SYS

#ifdef __FILE_H
#include __FILE_H
#endif

#ifdef __DIRECTORY_H
#include __DIRECTORY_H
#endif

#ifdef __LINK_H
#include __LINK_H
#endif

#ifdef __FREESPACEMANAGER_H
#include __FREESPACEMANAGER_H
#endif

#ifdef __CONTIGUOUSFILE_H
#include __CONTIGUOUSFILE_H
#endif

#ifdef __INODEFILE_H
#include __INODEFILE_H
#endif

#ifdef __MEDIATOR_H
#include __MEDIATOR_H
#endif

#ifdef __MEDIATOR_H
#include __MEDIATOR_H
#endif

#ifdef __FILEFACTORY_H
#include __FILEFACTORY_H
#endif

#ifdef __DESCRIPTORSMANAGER_H
#include __DESCRIPTORSMANAGER_H
#endif

#ifdef __FILESYSTEMINFORMATION_H
#include __FILESYSTEMINFORMATION_H
#endif


#endif
