// EPOS FileSystemInformation Declarations
//
// Author: laureano
// Documentation: $EPOS/doc/filesystem			Date: 28 Jun 2004

#ifndef __filesysteminformation_h
#define __filesysteminformation_h

#include <filesystem.h>
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

//<<Singleton>>
class FileSystemInformation:// public __INT(FileSystemInformation),
  protected fileSystem_Common
{
private:
    FileSystemInformation();
    ~FileSystemInformation();
    static FileSystemInformation *fsi;

    //Informations about the file system
    FileDescriptor* informations;    
    
    //where the blocks starts, after descriptors.
public:
    static FileSystemInformation* getFileSystemInformation();    
 
    /**
     * Get the file system type.
     */
    FileSystemType getFileSystemType();

    /**
     * Get the number of descriptors for file system.
     */
		unsigned int getNumberOfDescriptors();

    /**
     * Get the number of descriptor which are used for the bits map.
     */
    unsigned int getNumberDescriptorsForBitsMap();

    /**
     * Get the address of where the bits map start.
     */
    Address getWhereBitsMapStart();
    
    /**
     * Get the address of where the descriptors start.
     */
    Address getWhereDescriptorsStart();    

    /**
     * Get the address of where the data blocks start.
     */
    Address getWhereBlocksStart();

    /**
     * Update informations about the file system.
     */
    void refreshInformation();
};

__END_IMP
__END_SYS

#endif
