// EPOS FreeSpaceManager Declarations
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#ifndef __freespacemanager_h
#define __freespacemanager_h

#include <filesystem.h>
#include "mediator.h"
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

class FreeSpaceManager: protected fileSystem_Common
{
  private:
    Address firstBlock;
    Mediator *mediator;
 	  FreeSpaceManager();
    ~FreeSpaceManager();  
  
    /**
     * @return - The first pointer block.
     */
    Block* getFirstBlock();

    /**
    * @return - The last pointer block.
     */
    Block* getLastBlock();  
  
    /**
     * Return the last pointer for block and put the addres in
     * addressOfLastBlock.
     * @return - The last pointer block.
     */
    Block* getLastBlock(Address &addressOfLastBlock);  
  
    /**
     * Make the first block to pointer for the new last block.
     */
    void setLastBlock(Address addressOfLastBlock);

  public:

    /**
     * Get the FreeSpaceManager <<singleton>>
     */	  
	  static FreeSpaceManager* getFreeSpaceManager();

  
    /**
     * Get an address of freeBlock and set as used it.
     */
    Address getFreeBlock();

    /**
     * Set the block addressed by addressOfBlock as used.
	   * @return - True if the block is alloced, false otherwise.
     */
    bool getFreeBlock(Address addressOfBlock);

  
    /**
     * Get numberOfBlock contiguos.
     * @return - The address of fisrt block, or zero if it's imposible.
     */
    Address getFreeBlocks(unsigned long numberOfBlocks);        


    /**
     * Get numberOfBlock contiguos from address until address + numberOfBlock.
     * @return - True if worked, false otherwise.
     */
    bool getFreeBlocks(Address address, unsigned long numberOfBlocks);     


    /**
     * Release a block addressed by addressOfBlock, set it as free.
     */
    void releaseBlock(Address addressOfBlock);
    

    void FreeSpaceManager::refreshFileSystemInformation();


    /**
     * Create a new list of free block with all blocks from firstBlock until
     * sizeof(disk).
     */
    void setAllBlocksAsFree();
};

__END_IMP
__END_SYS

#endif
