// EPOS Link Declarations
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#ifndef __link_h
#define __link_h

#include <filesystem.h>
#include "common.h"
#include "directory.h"
//#include <traits.h>

__BEGIN_SYS
__BEGIN_IMP

class Link: public Directory
{
private:

    // Link private imports, types and constants

public:
    virtual ~Link();
	  void linkTo(File* aFile);
		void close();
    void setMode(OpenMode m);
    bool seek(long offset, SeekWhence whence);
    bool write(void* buffer, const unsigned long size);
    unsigned long read(void* buffer, const unsigned long size);
    virtual bool isDirectory();
    void setOpened(bool o);
		void getNextBlock();
    bool addFile(Address numberOfDescriptor, const char* name);
    bool removeFile(Address numberOfDescriptor);
    bool removeFile(char* name);
    File* findPath(const char* path);
    File* getFile(const char* name);
    int indexOfFile(const char* name);
    Address calculePhysicAddress(Address x);
    bool ensureCapacity(unsigned long x);
    Address getNextBlockAddress ();

private:
	File* file;
    // Link attributes
};

__END_IMP
__END_SYS

#endif
