// EPOS Mediator Declarations
//
// Author: laureano
// Documentation: $EPOS/doc/filesystem			Date: 09 Jun 2004

#ifndef __mediator_h
#define __mediator_h

#include <filesystem.h>
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

class Mediator //: public __INT(Mediator)
{
  private:
		Mediator();

  protected:		
		Block* mDiskContents;
    unsigned long  mDiskSize;
		static Mediator* mediator;
  public:
		virtual ~Mediator();
	
    /**
     * Read a block in disk between 0 and size - 1;
	   * @return a pointer for the read block.
     */	
    virtual Block* readBlock(Address address);
	
    virtual void writeBlock(Block *block, Address address);
	     
    static Mediator* getMediator();
  
    /**
     * @return - Ther number of blocks in the disk.
     */
	  virtual unsigned long getSizeOfDisk();
};

__END_IMP
__END_SYS
#endif
