// EPOS OpenFileTable Declarations
//
// Author: helo
// Documentation: $EPOS/doc/filesystem			Date: 28 Jun 2004

#ifndef __openfiletable_h
#define __openfiletable_h

#include <filesystem.h>
#include "common.h"

__BEGIN_SYS
__BEGIN_IMP

class OpenFileTable: protected fileSystem_Common
{
private:
	static OpenFileTable* openfiletable;
	OFTEntry* table;
	int findPlace(int f);
	int used;
  OpenFileTable();

    // OpenFileTable private imports, types and constants
public:
  ~OpenFileTable();
	bool add(int f, OpenMode mode);
    bool remove(FileDescriptor f, OpenMode openMode);
	static OpenFileTable* getInstance();
	bool isFull();
};

__END_IMP
__END_SYS

#endif
