#ifndef __STRING_H
#define __STRING_H


/**
 * Calculate the length of a string.
 */
inline int strlen(const char* str)
{
  int num;
  for (num = 0; str[num]; num++);    

  return num;
}

/**
 * Copy one string at str for another address at target.
 */
inline void strcpy(char *target, const char *str)
{
  int i;
  for (i = 0; str[i]; i++)
    target[i] = str[i];
  
  target[i] = '\0';
}

/**
 * Compare two strings.
 * @return 0 if them are equals, a negative number if the fist is less than 
 * second and a positive number otherwise.
 */
inline int strcmp(const char *str1, const char *str2)
{
  int i;    
  for (i = 0; str1[i] && str2[i] && (str1[i] == str2[i]); i++);			        
    
  return (str1[i] - str2[i]);
}

/**
 * Search by substr in str looking for end to begin.
 * @return - The index of substr in str, or -1 if the substr there is no
 * in str. 
 */
inline int find(const char *str, char substr)
{
  int i;
  for (i = strlen(str); (i >= 0) && (str[i] != substr); i--);

  return i;
}

/**
 * Search by a char in str looking for begin to end.
 * @return - The index of char in str, or -1 if the substr there is no
 * in str. 
 */
inline int firstchar(const char *str, char substr)
{
  int i;
  int end = strlen(str);
  for (i = 0; (i <  end) && (str[i] != substr); i--);

  return (i < end ? i : -1);
}

/**
 * Copy a substring of srt into tgt begining at start and finishing at begin.
 */
inline void substr(const char* src, char* tgt, int start, int begin)
{
 int i =0;
  for (; start <= begin; start++)
    tgt[i++] = src[start];

    tgt[i] = '\0';
}

#endif /* __STRING_H */
