// EPOS ContiguousFile Implementation
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#include <contiguousfile.h>
#include <descriptorsmanager.h>
#include <filesysteminformation.h>

#include <typeinfo>
#include <iostream>
using namespace std;


__BEGIN_SYS
__BEGIN_IMP

// Class attributes
// type ContiguousFile::attribute;

// Constructors
ContiguousFile::~ContiguousFile()
{
    cout << "~ContiguousFile()\n";
}

// Methods
Address ContiguousFile::calculePhysicAddress(Address logicAddress)
{
  cout << "ContiguousFile::calculatePhysicAddress(logicAddress= " << logicAddress << ")\n";
  Address physicAddress = logicAddress + getDescriptor()->ADDRESS*BLOCK_SIZE;
  cout << "    Logic Address (" << logicAddress << ") -> Physic Address (" << physicAddress << ")\n";
  
  return physicAddress;
}

Address ContiguousFile::getNextBlockAddress()
{
  cout << "ContiguousFile::getNextBlockAddress()\n";
  
  return blockAddress+1;
}

void ContiguousFile::getNextBlock()
{
  cout << "ContiguousFile::getNextBlock()\n";

  delete block;
  cout << "    Block " << blockAddress << " released\n";  
  block = Mediator::getMediator()->readBlock(++blockAddress);
  cout << "    Block " << blockAddress << " got in\n";
}

bool ContiguousFile::initialize()
{
  cout << "ContiguousFile::initialize()\n";

  //Set the type of file system
  Block* b;
  b = Mediator::getMediator()->readBlock(0);
  b->descriptor[0].fileSystemType = contiguosFile;
  cout << "    FileSystemType = contiguosFile\n";
  //

  //Get blocks for descriptors
  //+1 because the fisrt is a descriptors for information about the file system
  unsigned int descriptorsForBitsMap = DESCRIPTORS_NUMBER/(sizeof(FileDescriptor)*8);
  if (DESCRIPTORS_NUMBER%(sizeof(FileDescriptor)*8) != 0)
		descriptorsForBitsMap++;
	
	b->descriptor[0].descriptorsForBitsMap = descriptorsForBitsMap;
	cout << "    " << descriptorsForBitsMap << " descriptors alloced for Bits Map\n";
	b->descriptor[0].numOfDescriptors = DESCRIPTORS_NUMBER;
	cout << "    " << DESCRIPTORS_NUMBER << " descriptors alloced\n";

  //Set the init of date blocks
	Address numTotDescriptors = DESCRIPTORS_NUMBER + descriptorsForBitsMap + 1;	
	Address blocksStart = numTotDescriptors / DESCRIPTORS_FOR_BLOCK;
  cout << "******blocksStart = " << blocksStart << ", numTotDescriptors = " << numTotDescriptors << ", DESCRIPTORS_FOR_BLOCK = " << DESCRIPTORS_FOR_BLOCK << endl;
  if (numTotDescriptors % DESCRIPTORS_FOR_BLOCK != 0)
		blocksStart++;
	
	b->descriptor[0].blocksStart = blocksStart;	
	cout << "    The Data blocks start at " << blocksStart << "\n";
	//

	//Save all modifications
  Mediator::getMediator()->writeBlock(b, 0);
  delete b;
	//	
	
	//Refresh information about file system
	FileSystemInformation::getFileSystemInformation()->refreshInformation();
  cout << "    Updating file system information\n";
	//
	
	//Set all descriptors as fre
	DescriptorsManager* dm = DescriptorsManager::getDescriptorsManager();
	dm->setAllDescriptorsAsFree();
	cout << "    Releasing all descriptors\n";
	
  //Set all blocks as free		
  FreeSpaceManager *fsm = FreeSpaceManager::getFreeSpaceManager();
  fsm->setAllBlocksAsFree();
	cout << "    Releasing all blocks\n";
  //

	
  //Make the root directory
	FileDescriptor *fd = DescriptorsManager::getDescriptorsManager()->getFreeDescriptor(0);
	if (fd != 0)
	{
		fd->SIZE = 0;
		fd->ADDRESS = FreeSpaceManager::getFreeSpaceManager()->getFreeBlock();	
		DescriptorsManager::getDescriptorsManager()->writeDescriptor(fd, 0);	
		cout << "    Root directory created\n";
 	 //
	
		cout << "    The File System was created sussesfull\n";
		return true;
	}
	else
	{
		cout << "    Could not alloc fd=0. Cannot create FileSystem.\n";
		return false;
	}
}

bool ContiguousFile::ensureCapacity(unsigned long size)
{
	cout << "UNDONE!\n";
  return true;
}

// Class methods
__END_IMP
__END_SYS
