// EPOS Directory Implementation
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#include <directory.h>
#include <descriptorsmanager.h>
#include <filefactory.h>
#include <string.h>

#include <iostream>

using namespace std;

__BEGIN_SYS
__BEGIN_IMP

void Directory::getNextBlock()
{
	cout << "Directory::getNextBlock()\n";
  storage->getNextBlock();
}

Directory::Directory()
{
  storage = FileFactory::getFileFactory()->getNewFile();
}

Directory::~Directory()
{
  cout << "~Directory()\n";
  delete storage;
}


void Directory::setDescriptor(FileDescriptor* fd){
  File::setDescriptor(fd);
  storage->setDescriptor(fd); 
}

File* Directory::findPath(const char* path){
  char pathRelative[252];
  char dirName[252];
	cout << "creating the copy\n";
  strcpy(pathRelative, path);
  Directory* dir = this;
   if (strcmp(path, "/") == 0){
        return dir;
   }
  File* file;
  int pos;
	cout << "Going to while loop\n";
  while ((pos = firstchar(pathRelative, '/')) != -1)
	{
	  substr(pathRelative, dirName, 0, pos - 1);
	  substr(pathRelative, pathRelative, pos + 1, strlen(pathRelative));
		cout << "\tgetting file\n";
	  file = dir->getFile(dirName);
	  if (file != 0 && file->isDirectory())
		{	
	    dir = (Directory *)file;
		}
		else
		{
			cout << ":: returning null\n";
			return 0;
		}
	}
	cout << ":: returning dir\n";
	return dir;
}

File* Directory::getFile(const char* name)
{
	cout << "getting index of file\n";
  int index = indexOfFile(name);
	cout << "index = " << index << "\n";
  if (index == FILE_NOT_FOUND)
	{	
	  cout << "getFile(const char*) returning null\n";
    return 0;
	}
	else
	{
		DescriptorsManager* dm = DescriptorsManager::getDescriptorsManager();
	  FileDescriptor* fd = dm->getDescriptor(storage->block->file[index].numberOfDescriptor);
  
	  FileFactory* ff = FileFactory::getFileFactory();
		cout << "creating new file\n";
	  return ff->getNewFile(fd);
	}
}

int Directory::indexOfFile(const char* name)
{
  getBlock(descriptor->ADDRESS);
  
  
  for (unsigned int i = 0; i < descriptor->SIZE/sizeof(DirectoryEntry); i++)
  {
    unsigned char index = i % 4;
    
    if (strcmp(storage->block->file[index].fileName, name) == 0)
      //The file was founded
      return index;
    
    if (index == 3)
      getNextBlock();
  }
   
  return FILE_NOT_FOUND;
}

int Directory::indexOfFile(Address numberOfDescriptor)
{
  getBlock(descriptor->ADDRESS);
  
  int index;
  for (unsigned int i = 0; i < descriptor->SIZE/sizeof(DirectoryEntry); i++)
  {
    index = i % 4;
    
    if (storage->block->file[index].numberOfDescriptor == numberOfDescriptor)
      //The file was founded
      return index;
    
    if (index == 3)
      getNextBlock();
  }
   
  return FILE_NOT_FOUND;
}


bool Directory::removeFileOfIndex(int index)
{
  cout << "Directory::removeFileOfIndex(" << index << ")\n";
  DescriptorsManager* dm = DescriptorsManager::getDescriptorsManager();

  FreeSpaceManager* fsm; //FreeSpaceManager <<Singleton>>
  FileDescriptor* des;   //Descriptor of file will be deleted.
  
  fsm = FreeSpaceManager::getFreeSpaceManager();
  des = dm->getDescriptor(storage->block->file[index].numberOfDescriptor);

  for (unsigned int i = 0; i < des->SIZE/BLOCK_SIZE; i++)
  { 
    fsm->releaseBlock( calculePhysicAddress(i) );
    cout << "Block " << calculePhysicAddress(i) << " released\n";
  }  

  dm->releaseDescriptor(storage->block->file[index].numberOfDescriptor);  
  delete des;
  
  return true;
}

bool Directory::addFile(Address numberOfDescriptor, const char* name)
{
  cout << "Directory::addFile(" << numberOfDescriptor << ", "
                                              << name << ")\n";

  if (strlen(name) > MAX_TAM_FILE_NAME)
	{
	 cout << "The file name is too big\n";
	 return false; 
	}

  if (indexOfFile(name) != FILE_NOT_FOUND)
	{	
	  cout << "There is another file with the same name\n";
		return false;
	}
  
  unsigned char index;  //Index of DirectoryEntry in the block;  
  index = (descriptor->SIZE % BLOCK_SIZE) / sizeof(DirectoryEntry);
  if (index == 0)
    //It's necessary a new block
    getNextBlock();

  storage->block->file[index].numberOfDescriptor = numberOfDescriptor;
  strcpy(block->file[index].fileName, name);
  Mediator::getMediator()->writeBlock(block, blockAddress);
  
  DescriptorsManager* dm = DescriptorsManager::getDescriptorsManager();
  descriptor->SIZE += sizeof(DirectoryEntry);  
  dm->writeDescriptor(descriptor, descriptorAddress);  

  cout << "The file was added in directory\n";
  cout << "It has " << descriptor->SIZE << " bytes now\n";
  
  return true;
}


bool Directory::removeFile(Address numberOfDescriptor)
{
  cout << "Directory::removeFile(" << numberOfDescriptor << ")\n";
  
  int index = indexOfFile(numberOfDescriptor);
  if (index == FILE_NOT_FOUND)
	{	
	  cout << "File " << numberOfDescriptor << " not found\n";
		return false;
	}
  
  return removeFileOfIndex(index);
}


bool Directory::removeFile(char* name)
{
  cout << "Directory::removeFile(" << name << ")\n";

  int index = indexOfFile(name);
  if (index == FILE_NOT_FOUND)
	{	
	  cout << "File " << name << " not found\n";
		return false;
	}
  
  return removeFileOfIndex(index);
}

Address Directory::calculePhysicAddress(Address a)
{
	return storage->calculePhysicAddress(a);
}

bool Directory::ensureCapacity(long unsigned int x)
{
	return storage->ensureCapacity(x);
}

Address Directory::getNextBlockAddress ()
{
	return storage->getNextBlockAddress();
}

unsigned long Directory::read(void* buffer, unsigned long size)
{
	return storage->read(buffer,size);
}

bool Directory::write(void* buffer, unsigned long size)
{
	return storage->write(buffer,size);
}

bool Directory::isDirectory()
{
	// It is a directory, by instance
	return true;
}
__END_IMP
__END_SYS
