// EPOS File Implementation
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#include <file.h>

#include <filefactory.h>
#include <directory.h>
#include <string.h>
#include <common.h>
#include <mediator.h>
#include <descriptorsmanager.h>

#include <typeinfo>
#include <iostream>

using std::cout;

__BEGIN_SYS
__BEGIN_IMP

OpenFileTable* File::table;

File::~File()
{
    cout << "~File()\n";
}

Directory* File::getRoot(){
	cout << "getRoot()\n";
	FileDescriptor* desc = DescriptorsManager::getDescriptorsManager()->getDescriptor(0);
	cout << "got descriptor.\n";
	return (Directory*)FileFactory::getFileFactory()->getNewFile(desc);
}

void File::setOpened(bool o){
	opened = o;
}

void File::close(){
  if (table ==0) OpenFileTable::getInstance();
  opened = !table->remove(*descriptor, openmode);  // says if file was closed so many times as was opened

}
void File::setMode(OpenMode m){
	openmode = m;
}

File* File::open(char* path, OpenMode mode)
{
  bool worked = false;
  File* result = 0;
  if (table ==0) table = OpenFileTable::getInstance(); 
  Directory* root = getRoot();
	cout << "calculating position\n";
  int position = find(path, '/');
  char path3[252];
	cout << "calculating path\n";
  substr(path, path3, 0, position);  // path3 = caminho de diretorio
  char name[252];
  substr(path, name, position + 1, strlen(path)); 	// name = nome do aquivo sendo aberto
 cout << "path = "<< path << "\n";
 cout << "path3 = " << path3 << "\n";
 cout << "name = " << name << "\n";
  result = root->findPath(path); 
  if (result != 0){		//file already exists
	  if ((result->isDirectory()) && (mode != directory))
		  return 0;
	  if ((!result->isDirectory())&& (mode == directory))
		  return 0;
	  if (!result->isDirectory()){	// openning a file
		 bool added = table->add(result->descriptor->ADDRESS, mode);
		 if (!added)
			return 0;
		 result->setMode(mode);
		 result->setOpened(true);
		 return result;
	  }
	  else{		//openning a directory
		  return result;
	  }
  }else{		//file doesn't exists yet
		cout << "file does not yes exists ";
				if (mode == directory)
				{  	//openning a new directory
					cout << "and we're opening a directory\n";
					Directory* created = new Directory();
					Directory* local = (Directory *)root->findPath(path3);
					bool in = local->addFile(created->descriptor->ADDRESS, name);
					if (!in) return 0;	
					return (File *)created;			 
				}
				else
				{		// opening a new file
					cout << "and we're opening a file\n";
					if (mode == readOnly)
					{
						cout << "cannot open read-only a non-existing file. return=0\n";
						return 0;		// abrindo pra leitura um arquivo q naum exist
					}
					if (table->isFull())
					{
						cout << "too many open files. return=0\n";
						return 0;  
					}
					FileFactory* fac = FileFactory::getFileFactory();
					File* created = fac->getNewFile();
					cout << "created the new file\n";
					created->setMode(mode);
					cout << "setted it's mode, finding path now\n";
					Directory* local = (Directory *)root->findPath(path3);// find directory that contains this file
					cout << "adding the file to the directory\n";
					bool in = local->addFile(created->descriptor->ADDRESS, name);
					if (!in)
					{
						cout << "directory refused to add the file, return=0\n";
						 return 0;			// diretorio naum conseguiu inserir o novo arquivo
					}
					cout << "adding to the OFT\n";
					worked = table->add(created->descriptor->ADDRESS, mode);
					created->setOpened(true);		
					cout << "returning file.\n";
					return created;
				}
  }
  return result;
}

FileDescriptor* File::getDescriptor()
{
	return descriptor;
}

void File::getBlock(Address newAddress)
{
  if (blockAddress != newAddress)
  {
    delete block;
    cout << "Block " << blockAddress << " released\n";
    blockAddress = newAddress;
    //block = DiskMediatorFactory::getMediator()->readBlock(blockAddress);
    cout << "Block " << blockAddress << " got in\n";
  }
  else
    cout << "The block asked is the actual block\n";
}


bool File::seek(long offset, SeekWhence whence)
{
  cout << "Current byte is " << curByte << " in block " << block << "\n";
  Address logicAddress;
  Address physicAddress;
  Address curAddress = (blockAddress*BLOCK_SIZE + curByte);

  cout << "Current byte is " << curByte << " in block " << block << "\n";
  cout << "Current address is " << curAddress;

  switch (whence) {
    case seekCur:
      logicAddress =  curAddress + offset;
      break;
    case seekEnd:
      logicAddress = descriptor->SIZE - offset;
      break;    
    case seekBegin:
      logicAddress = offset;
  }
   
  if ( (logicAddress < 0) || (logicAddress > descriptor->SIZE) )
    return false;
   
  physicAddress = calculePhysicAddress(logicAddress);
  curByte = physicAddress % BLOCK_SIZE;
	 
	//calcule the block address
	Address blockAddressTarget = physicAddress/BLOCK_SIZE;
	getBlock(blockAddressTarget);
   
  cout << "Target address is:\n";
  cout << "  Logic address " << logicAddress << "\n";
  cout << "  Physic address " << physicAddress << "\n";
 
  return true;
}

unsigned long File::read(void* buffer, const unsigned long size)
{
	cout << "Reading " << size << " bytes into " << &buffer << "\n";
	// -- not sure if block's content should be local or class
	// -- memory x performance thing
	unsigned long current = blockAddress * BLOCK_SIZE + curByte;
	unsigned long realSize = (size + current > descriptor->SIZE ? descriptor->SIZE-current : size );
	unsigned char* target = (unsigned char*)buffer;
	unsigned long idx = 0;
	for (unsigned long i = 0; i < realSize; ++i)
	{
		if (curByte == BLOCK_SIZE)
		{
			cout << "Current block was entirely read, get the next one: ";
			blockAddress = getNextBlockAddress();
			cout << blockAddress << "\n";
			//block->byte = DiskMediatorFactory::getMediator()->readBlock(blockAddress);
			curByte = 0;
		}
		target[idx++] = block->byte[curByte++];
	}
	cout << "Read " << realSize << " bytes from file.\n";
	return realSize;
}

bool File::write(void* buffer, const unsigned long size)
{
	if (ensureCapacity(curAddress + size))
	{
		cout << "Writing " << size << " bytes\n";
		
		//block->byte = DiskMediatorFactory::getMediator()->readBlock(blockAddress);
		
		unsigned char* source = (unsigned char*)buffer;
		unsigned long idx = 0;
		
		for (unsigned long byte = 0; byte < size; ++byte)
		{
			if (curByte == BLOCK_SIZE)
			{
				//DiskMediatorFactory::getMediator()>writeBlock(blockAddress,block->byte);
				//blockAddress = getNextBlockAddress();
				//block->byte = mediator->readBlock(blockAddress);
				curByte = 0;
			}
			block->byte[curByte++] = source[idx++];
		}
		
		// if curByte == 0 the block is a fresh one from the mediator
		// no changes, no need to write it back...
		if (curByte > 0)
		{
			//mediator->writeBlock(blockAddress,block->byte);
		}
		
		return true;
	}
	else
	{
		return false;
	}
}

bool File::isDirectory()
{
	// not a directory, by instance
	return false;
}
__END_IMP
__END_SYS
