// EPOS FileFactory Implementation
//
// Author: gabriel
// Documentation: $EPOS/doc/filesystem			Date: 25 Jun 2004

#include <directory.h>
#include <filefactory.h>
#include <filesysteminformation.h>
#include <contiguousfile.h>

#include <iostream>
using namespace std;

__BEGIN_SYS
__BEGIN_IMP

FileFactory* FileFactory::filefactory;

FileFactory::FileFactory()
{
    cout << "FileFactory()\n";
}

FileFactory::~FileFactory()
{
    cout << "~FileFactory()\n";
}

FileFactory* FileFactory::getFileFactory()
{
  if (filefactory == 0) {    
    filefactory = new FileFactory();
    FileSystemInformation* fsi = FileSystemInformation::getFileSystemInformation();
    filefactory->fileSystemType = fsi->getFileSystemType();
  }
  
  return filefactory;
}

File* FileFactory::getNewFile()
{
  File* file;

  switch (fileSystemType)
  {
	  case contiguosFile:
      file = new ContiguousFile();
  		break;
  }

  return file;
}

File* FileFactory::getNewFile(FileDescriptor* fd)
{
  File* file;
  if (fd->TYPE == DirectoryType)
    file = new Directory();
  else
    file = new ContiguousFile();
          
  file->setDescriptor(fd);
  return file;
}


__END_IMP
__END_SYS
