// EPOS FileSystemInformation Implementation
//
// Author: laureano
// Documentation: $EPOS/doc/filesystem			Date: 28 Jun 2004

#include <filesysteminformation.h>
#include <mediator.h>

FileSystemInformation* FileSystemInformation::fsi;

#include <iostream>
using namespace std;

__BEGIN_SYS
__BEGIN_IMP

FileSystemInformation::FileSystemInformation()
{
  cout << "FileSystemInformation()\n";
  informations = new FileDescriptor;
}

FileSystemInformation::~FileSystemInformation()
{
  cout << "~FileSystemInformation()\n";
  delete informations;
}


FileSystemInformation* FileSystemInformation::getFileSystemInformation()
{
  if (fsi == 0)
  {
    fsi = new FileSystemInformation();
    fsi->refreshInformation();
  }
  
  return fsi;
}


FileSystemType FileSystemInformation::getFileSystemType()
{
  return informations->fileSystemType;
}


unsigned int FileSystemInformation::getNumberOfDescriptors()
{
  return informations->numOfDescriptors;
}


unsigned int FileSystemInformation::getNumberDescriptorsForBitsMap()
{
  return informations->descriptorsForBitsMap;
}


Address FileSystemInformation::getWhereBitsMapStart()
{
  return 1;
}

    
Address FileSystemInformation::getWhereDescriptorsStart()
{
  return informations->descriptorsForBitsMap;
}


Address FileSystemInformation::getWhereBlocksStart()
{
  return informations->blocksStart;
}


void FileSystemInformation::refreshInformation()
{
  Block* firstBlock;  
  
  firstBlock = Mediator::getMediator()->readBlock(0);
  copy(&firstBlock->descriptor[0], informations, sizeof(FileDescriptor));
  
  delete firstBlock;
}


__END_IMP
__END_SYS
