// EPOS FreeSpaceManager Implementation
//
// Author: otavio
// Documentation: $EPOS/doc/filesystem			Date: 02 Jun 2004

#include <freespacemanager.h>
#include <filesysteminformation.h>
#include <iostream>
using namespace std;

__BEGIN_SYS
__BEGIN_IMP

FreeSpaceManager::FreeSpaceManager()
{
  cout << "FreeSpaceManager()\n";
	mediator = Mediator::getMediator();
}


FreeSpaceManager::~FreeSpaceManager()
{
  cout << "~FreeSpaceManager()\n";
}


Block* FreeSpaceManager::getFirstBlock()
{
  return mediator->readBlock(firstBlock);
}


Block* FreeSpaceManager::getLastBlock()
{
  Block* firstBlock = getFirstBlock();
  Address numberOfLastBlock = firstBlock->freeBlock[0];
  delete firstBlock;
  
  return mediator->readBlock(numberOfLastBlock);
}


Block* FreeSpaceManager::getLastBlock(Address &addressOfLastBlock)
{
  Block* firstBlock = getFirstBlock();
  addressOfLastBlock = firstBlock->freeBlock[0];
  delete firstBlock;

  return mediator->readBlock(addressOfLastBlock);
}

Address FreeSpaceManager::getFreeBlock()
{
  //cout << "getFreeBlock()\n";
  Address addressOfBlock;
  Address addressOfLastBlock;

  Block* block = getLastBlock(addressOfLastBlock);  
  //cout << "     Adress of last block is " << addressOfLastBlock << endl ;
  if (block->freeBlock[1] == 0)
  {
    ///cout << "    The block is empty, himself will be returned" << endl;
    addressOfLastBlock = block->freeBlock[0];
    delete block;
  
    //Set the previous block as last
    block = mediator->readBlock(addressOfLastBlock);
    addressOfBlock = block->freeBlock[ADDRESS_FOR_BLOCK - 1]; 
    block->freeBlock[ADDRESS_FOR_BLOCK - 1] = 0;
    mediator->writeBlock(block, addressOfLastBlock);
    delete block;
  
    //cout << "    The new last block is " << addressOfLastBlock << "\n";
    setLastBlock(addressOfLastBlock);
  }
  else
  {
    //cout << "    An address inside the block will be returned\n";
    //because the last pointet for the next
    unsigned int i = ADDRESS_FOR_BLOCK - 2;
    for (; block->freeBlock[i] == 0; i--);
    //cout << "    The Address index(" << i << ") will be returned\n";
    addressOfBlock = block->freeBlock[i];
    //cout << "    The Adress is " << addressOfBlock << endl;
    block->freeBlock[i] = 0;
    mediator->writeBlock(block, addressOfLastBlock);    
    delete block;
  }

  return addressOfBlock;
}


bool FreeSpaceManager::getFreeBlock(Address addressOfBlock)
{
  Block *block;      
  Address addBlock = firstBlock;

  while (addBlock)
  {
    block = mediator->readBlock(addBlock);
  
    for (unsigned int i = 1; i < ADDRESS_FOR_BLOCK - 1; i++)
    {
      if (block->freeBlock[i] == addressOfBlock)
      {
        Address newAddress = getFreeBlock();  //Get another address
        if (newAddress != addressOfBlock)
        {
          block->freeBlock[i] = newAddress;
          mediator->writeBlock(block, addBlock);
        }
        delete block;

        return true;        
      }        
    }
    
    addBlock = block->freeBlock[ADDRESS_FOR_BLOCK - 1];
    delete block;
  }
  
  return false;
}


Address FreeSpaceManager::getFreeBlocks(unsigned long numberOfBlocks)
{
  cout << "getFreeBlocks(" << numberOfBlocks << ")\n";

  Block *block;      
  Address addBlock = firstBlock;

  while (addBlock)
  {
    block = mediator->readBlock(addBlock);
  
    for (unsigned int i = 1; i < ADDRESS_FOR_BLOCK - 1; i++)
    {
		  unsigned long j;
		  for (j = 1; j < numberOfBlocks; j++)
			{
		    if (getFreeBlock(block->freeBlock[i] + j) == false)
				{
				  //release alls
				  for (; j > 0; j--)
					  releaseBlock(block->freeBlock[i] + j);
			  }
			}
		
      if (j == numberOfBlocks)
      {
			  //All was alloced
			  Address addressOfBlock = block->freeBlock[i];			
			  Address newAddress = getFreeBlock();  //Get another address			  
        if (newAddress != addressOfBlock)
        {
          block->freeBlock[i] = newAddress;
          mediator->writeBlock(block, addBlock);
        }
        delete block;
			
			  return addressOfBlock;
      }        
    }
    
    addBlock = block->freeBlock[ADDRESS_FOR_BLOCK - 1];
    delete block;
  }
  
  //It's impossible
  return 0;
}


bool FreeSpaceManager::getFreeBlocks(Address address, unsigned long numberOfBlocks)
{
  cout << "getFreeBlocks(" << address << ", " << numberOfBlocks << ")\n";

  for (unsigned int i = 0; i < numberOfBlocks; i++)
  {
	  if (getFreeBlock(address + i) == false)
		{
		  //if didn't work
		  for (i = i - 1; i >= 0; i--)
			{
			  //release the blocks was alloced
			  releaseBlock(address + i);
			}
		
		  return false;
		}
	}

 
  return true;
}


FreeSpaceManager* FreeSpaceManager::getFreeSpaceManager()
{
  static FreeSpaceManager* fsm;

  if (fsm == 0)
  {
		fsm = new FreeSpaceManager();  
    fsm->refreshFileSystemInformation();
  }
	
  return fsm;
}


void FreeSpaceManager::refreshFileSystemInformation()
{
  cout << "refreshFileSystemType()\n";
  firstBlock = FileSystemInformation::getFileSystemInformation()->getWhereBlocksStart();  
}


void FreeSpaceManager::releaseBlock(Address addressOfBlock)
{
  cout << "releaseBlock(" << addressOfBlock << ")\n";
  
  Block *b;       //Block like Object block
  Address* block; //Block like array of Addresses
  Address numberOfBlock;

  b = getFirstBlock();
  block = (Address *)b;
  numberOfBlock = block[0];
  if (numberOfBlock != firstBlock) 
  {
    //if aren't the same block
    delete b;
    b = mediator->readBlock(block[0]);
    block = (Address *)b;
  }
  
  unsigned int i = BLOCK_SIZE/sizeof(Address) - 2;
  if (block[i] != 0)
  {
    block[i + 1] = addressOfBlock;   
    mediator->writeBlock(b, numberOfBlock);
    delete b;
  
    //Erase new pointer block
    b = mediator->readBlock(addressOfBlock);
    block = (Address *)b;
    block[0] = numberOfBlock;
    unsigned int j = BLOCK_SIZE/sizeof(Address) - 1;        
    for (; j > 0; j--)
      block[j] = 0;
    mediator->writeBlock(b, numberOfBlock);
    delete b;
    //

    setLastBlock(addressOfBlock);  }
  else
  {
    i--;
    for (; block[i] != 0; i--);
    block[i] = addressOfBlock;   
    
    mediator->writeBlock(b, numberOfBlock);
    delete b;
  }
}


void FreeSpaceManager::setAllBlocksAsFree()
{
  cout << "setAllBlocksAsFree()\n";

  Block *block; 
  Address *freeBlock;
  unsigned long sizeOfDisk = mediator->getSizeOfDisk();
  cout << "     Size of disk = " << sizeOfDisk << endl; 
  unsigned long numberOfBlocks = sizeOfDisk - firstBlock;
  cout << "     Number of blocks = " << numberOfBlocks << endl;
  //-2 because one is for previous and another for the next
  unsigned long pointersForBlock = BLOCK_SIZE/sizeof(Address) - 2;
  cout << "    Pointers for block = " << (int)pointersForBlock << endl;  

  //+1 because the self block, it is not aponter for none block
  unsigned long numBlocksForPointers = numberOfBlocks/(pointersForBlock + 1);
  if (numberOfBlocks%(pointersForBlock + 1) != 0)
    numBlocksForPointers++;
  cout << "    Number of blocks for pointers = " << numBlocksForPointers << endl;

  Address numFreeBlock = numBlocksForPointers + 1;
  cout << "    The first free block is " << numFreeBlock << endl;

  block = mediator->readBlock(firstBlock);
  block->freeBlock[0] = firstBlock + numBlocksForPointers - 1;  //The First apointer to last
  cout << "    The last block is " << firstBlock + numBlocksForPointers - 1 << endl;
  
  if (numBlocksForPointers == 1)
  {    
    cout << "    There is only one block for pointer" <<  endl;
    unsigned int j;
    for (j = 1; numFreeBlock <= sizeOfDisk; j++)
      block->freeBlock[j] = numFreeBlock++;  
    for (; j < pointersForBlock; j++)
      block->freeBlock[j] = 0;  
    block->freeBlock[j] = firstBlock + 1;
    mediator->writeBlock(block, firstBlock);  
    delete block;
  }
  else
  {  
    cout << "    Number of blocks for pointers = " << numBlocksForPointers << endl;
    unsigned int j;
    for (j = 1; j <= pointersForBlock; j++)
      block->freeBlock[j] = numFreeBlock++;  
    block->freeBlock[j] = firstBlock + 1;
    mediator->writeBlock(block, firstBlock);  
    delete block;
    
    //set the common blocks
    for (unsigned int i = 1; i < numBlocksForPointers - 1; i++)
    {
      block = mediator->readBlock(firstBlock + i);
      block->freeBlock[0] = firstBlock + i - 1;    
      for (j = 1; j <= pointersForBlock; j++)
        block->freeBlock[j] = numFreeBlock++;  
 
      block->freeBlock[j] = firstBlock + i + 1;  
      mediator->writeBlock(block, firstBlock + i);  
      delete block;
    }
    
    //set the last block
    block = mediator->readBlock(firstBlock + numBlocksForPointers);
    block->freeBlock[0] = firstBlock + numBlocksForPointers - 1;    
    for (j = 1; numFreeBlock <= sizeOfDisk; j++)
      block->freeBlock[j] = numFreeBlock++;  
    for (; j < pointersForBlock; j++)
      block->freeBlock[j] = 0;  
    block->freeBlock[j] = firstBlock;  
    mediator->writeBlock(block, firstBlock + numBlocksForPointers);  
    delete block;
  }
}

void FreeSpaceManager::setLastBlock(Address addressOfLastBlock)
{
  //Make the first know the last
  Block* b = getFirstBlock();
  b->freeBlock[0] = addressOfLastBlock;
  mediator->writeBlock(b, firstBlock);
  delete b;
  //
}


__END_IMP
__END_SYS
