// EPOS Link Implementation
//
// Author: laureano
// Documentation: $EPOS/doc/filesystem			Date: 28 Jun 2004

#include <link.h>

#include <iostream>
using namespace std;

__BEGIN_SYS
__BEGIN_IMP

// Class attributes
// type Link::attribute;


// Constructors
Link::~Link()
{
    cout << "~Link()\n";
}

// Methods

bool Link::seek(long offset, SeekWhence whence)
{
	if (file != 0)
	{
		return file->seek(offset,whence);
	}
	cout << "Requesting method on non-linked Link\n";
	return false;
}

bool Link::write(void* buffer, const unsigned long size)
{
	if (file != 0)
	{
		return file->write(buffer,size);
	}
	cout << "Requesting method on non-linked Link\n";
	return false;
}

unsigned long Link::read(void* buffer, const unsigned long size)
{
	if (file != 0)
	{
		return file->read(buffer,size);
	}
	cout << "Requesting method on non-linked Link\n";
	return 0;
}

bool Link::isDirectory()
{
	if (file != 0)
	{
		// by instance a Link is not a directory, but it's better
		// to return the real value as a link to a link is allowed...
		return file->isDirectory();
	}
	cout << "Requesting method on non-linked Link\n";
	return false;
}

Address Link::calculePhysicAddress(Address x)
{
	cout << "never called!!!\n";
	return 0;
}
bool Link::ensureCapacity(unsigned long x)
{
	cout << "never called!!!\n";
	return false;
}

Address Link::getNextBlockAddress ()
{
	cout << "never called!!!\n";
	return 0;
}

void Link::getNextBlock()
{
	cout << "never called!!!\n";
}


// directory only stuff
bool Link::addFile(Address numberOfDescriptor, const char* name)
{
	if (file != 0)
	{
		if (file->isDirectory())
		{
			return ((Directory*)file)->addFile(numberOfDescriptor,name);
		}
		else
		{
			cout << "Requesting directory only method on non-directory link\n";
		}
	}
	cout << "Requesting method on non-linked Link\n";
	return false;
}

bool Link::removeFile(Address numberOfDescriptor)
{
	if (file != 0)
	{
		if (file->isDirectory())
		{
			return ((Directory*)file)->removeFile(numberOfDescriptor);
		}
		else
		{
			cout << "Requesting directory only method on non-directory link\n";
		}
	}
	cout << "Requesting method on non-linked Link\n";
	return false;
}

bool Link::removeFile(char* name)
{
	if (file != 0)
	{
		if (file->isDirectory())
		{
			return ((Directory*)file)->removeFile(name);
		}
		else
		{
			cout << "Requesting directory only method on non-directory link\n";
		}
	}
	cout << "Requesting method on non-linked Link\n";
	return false;
}

// link stuff
void Link::linkTo(File* aFile)
{
	cout << "Linking to " << aFile << "\n";
	file = aFile;
}



// Class methods
__END_IMP
__END_SYS
