// EPOS Mediator Implementation
//
// Author: laureano
// Documentation: $EPOS/doc/filesystem			Date: 28 Jun 2004

#include <mediator.h>

#include <iostream>
using namespace std;

__BEGIN_SYS
__BEGIN_IMP

// Class attributes
// type Mediator::attribute;

// Constructors
Mediator::Mediator()
        : mDiskSize(512*BLOCK_SIZE)
{
  cout << "Mediator()\n";
	cout << "\tDiskSize = " << mDiskSize << "\n";
  mDiskContents = new Block[mDiskSize];
	cout << "Mediator created\n";
}

Mediator::~Mediator()
{
  cout << "~Mediator()\n";
  delete mDiskContents;
}


Block* Mediator::readBlock(Address blockAddress)
{
//<<<<<<< mediator.cc
 // cout << "Mediator::readBlock(blockAddress= " << blockAddress << ")\n";
//=======
//  cout << "Mediator::readBlock(blockAddress= " << blockAddress << ")\n";
//>>>>>>> 1.4
	Block* newBlock = new Block();
	*newBlock = mDiskContents[blockAddress];
  return newBlock;
}

void Mediator::writeBlock(Block* contents, Address blockAddress)
{
//<<<<<<< mediator.cc
  //cout << "Mediator::writeBlock(contents= " << contents << ", blockAddress= " << blockAddress << ")\n";
  copy(contents, &mDiskContents[blockAddress], BLOCK_SIZE);
//=======
  //cout << "Mediator::writeBlock(contents= " << contents << ", blockAddress= " << blockAddress << ")\n";
	mDiskContents[blockAddress] = *contents;
//>>>>>>> 1.4
}


Mediator* Mediator::mediator;


Mediator* Mediator::getMediator()
{
	if (mediator == 0)
	{
		mediator = new Mediator();
	}
	return mediator;
}


unsigned long Mediator::getSizeOfDisk()
{
	return mDiskSize;
}

// Methods

// Class methods
__END_IMP
__END_SYS
