// EPOS OpenFileTable Implementation
//
// Author: helo
// Documentation: $EPOS/doc/filesystem			Date: 28 Jun 2004

#include <openfiletable.h>

#include <iostream>
using namespace std;

__BEGIN_SYS
__BEGIN_IMP

OpenFileTable* OpenFileTable::openfiletable;

// Class attributes
// type OpenFileTable::attribute;

// Constructors
OpenFileTable::~OpenFileTable()
{
    cout << "~OpenFileTable()\n";
}

// Methods

OpenFileTable* OpenFileTable::getInstance()
{
    if(openfiletable == 0)
    {
        openfiletable = new OpenFileTable();
    }
    return openfiletable;
}

bool OpenFileTable::isFull(){
	return (used == OFTsize);
}

OpenFileTable::OpenFileTable(){
	used = 0;
	table = new OFTEntry[OFTsize];
}

bool OpenFileTable::add(int address, OpenMode mode){  // adiciona
  	bool added = false;
    int position = findPlace(address);
    if (position == -1){
		return false;		// full table 
	}
	if (table[position].timesOpenned !=0){		//file already opened
	if (((table[position].writers == 0) && ((mode == readWrite) || (mode ==readWriteTruncate))) || 
		((table[position].writers >0) && (mode == readOnly))){
		   table[position].timesOpenned ++;
		   if ((mode == readWrite) || (mode ==readWriteTruncate)){
		     table[position].writers++;
		   }
		   added = true;
		 }
		/*else{	 		 
	 	 added = false; 	(file already been written)
		}*/
	 }
     else{		// first opening
       OFTEntry e(address, 1, mode);  // addressOfDescriptor, timesOpenned, openMode
       table[position] = e;
       used++;
	   added = true;
     }
  return added;
}

int OpenFileTable::findPlace(int f){  
  int place = -1;
  for(int i=0; i<OFTsize; i++){
	if (table[i].addressOfDescriptor == f){  // file already opened
		place = i;
		break;
	}
  }
  if ((place == -1)&&(used<OFTsize)){
	for(int i=0; i<OFTsize; i++){
		if (table[i].timesOpenned == 0){
			place = i;
			break;
		}
	}
  }
  return place;
}

bool OpenFileTable::remove(FileDescriptor fd, OpenMode openMode){  	
    int place = -1;
    for(int i=0; i<OFTsize; i++){
	if (table[i].addressOfDescriptor == fd.ADDRESS){
		place = i;
		break;
	}
    }
    table[place].timesOpenned --;
	if ((openMode == readWrite) || (openMode == readWriteTruncate)){
      table[place].writers --; 
	}
    bool last = false;
    if (table[place].timesOpenned == 0){
		last = true;
		used--;
    }
    return last;
}

// Class methods
__END_IMP
__END_SYS
