#include <file.h>
#include <contiguousfile.h>
#include <mediator.h>
#include <filesysteminformation.h>
#include <common.h>
#include <descriptorsmanager.h>
#include <iostream>


int main()
{
  ContiguousFile::initialize();
  
  
  cout << endl << "******* Testing DescriptorsManager *******\n"; 
  DescriptorsManager* dm = DescriptorsManager::getDescriptorsManager();
  
  cout << "Testing FileDescriptor* getDescriptor(0) Root Directory\n";
  FileDescriptor* fd;
  for (int i = 0; i < 2; i++)
  {
    cout << "Testing the reading\n";
    fd = dm->getDescriptor(0); //Get the root direcotry
    cout << "    TYPE = ";
    switch (fd->TYPE)
    {
      case DirectoryType:
        cout << "DirectoryType\n";
        break;
      case LinkType:
        cout << "LinkType\n";
        break;
      case ContiguousType:
        cout << "ContiguousType\n";
        break;
      case INodeType:
        cout << "INodeType\n";
        break;
    }
    cout << "    DATE = " << fd->DATE << endl;
    cout << "    ADDRESS = " << fd->ADDRESS << endl;
    cout << "    SIZE = " << fd->SIZE << endl;
    cout << "end of FileDescriptor* getDescriptor(Address) test\n\n";

    cout << "Testing the writing, fd->DATE = 110\n";
    fd->DATE = 110;
    dm->writeDescriptor(fd, 0);
 
    delete fd;
  }

  cout << "Testing Adress getFreeDescriptor()\n";

  for (char i = 0; i < 5; i++)
  {
    Address add = dm->getFreeDescriptor();
    cout << "    getFreeDescriptor() == " << add << endl;
    cout << "    Trying to get again, should be fail\n";
    fd = dm->getFreeDescriptor(add);
    cout << "    " << (fd == 0?"fail":"sucessfull") << endl;
    if (fd != 0)
      delete fd;
  }

  cout << "end of Adress getFreeDescriptor()\n\n";  


  cout << "Testing Address FileDescriptor* getFreeDescriptor(Address)\n";
  
  cout << "    Trying to get a busy descriptor(0), that should be fail\n";
  fd = dm->getFreeDescriptor(3);
  if (fd != 0)
    delete fd;
  cout << "    " << (fd == 0?"fail":"sucessfull") << endl;  
  if (fd != 0)
    delete fd; 
  cout << "    Trying to get again, should be fail\n";
  fd = dm->getFreeDescriptor(3);
  cout << "    " << (fd == 0?"fail":"sucessfull") << endl;
  if (fd != 0)
    delete fd;

  cout << "    Trying to get a free descriptor(10), that should be sussesfull\n";
  fd = dm->getFreeDescriptor(10);
  cout << "    " << (fd == 0?"fail":"sucessfull") << endl;
  if (fd != 0)
    delete fd;
  cout << "    Trying to get again, should be fail\n";
  fd = dm->getFreeDescriptor(10);
  cout << "    " << (fd == 0?"fail":"sucessfull") << endl;
  if (fd != 0)
    delete fd;

  cout << "Testing the releasing of a descriptor\n";
  fd = dm->getFreeDescriptor(20);
  if (fd != 0)
    delete fd;

  dm->releaseDescriptor(20);
  cout << "    Descriptor(20) was released\n";
  
  cout << "    Trying get out Descriptor(20) again, should be sucessfull\n";
 fd = dm->getFreeDescriptor(20);
  cout << "    " << (fd == 0?"fail":"sucessfull") << endl;
  if (fd != 0)
    delete fd;

  cout << "end of Address FileDescriptor* getFreeDescriptor(Address)\n\n";
}
