#include <file.h>
#include <contiguousfile.h>
#include <mediator.h>
#include <filesysteminformation.h>
#include <common.h>
#include <freespacemanager.h>
#include <iostream>


int main()
{
  ContiguousFile::initialize();
  
 
  cout << "\n\n\n******* Testing FreeSpaceManager *******" << endl << endl;
  FreeSpaceManager* fsm = FreeSpaceManager::getFreeSpaceManager();


  cout << "Testing Address getFreeBlock()\n";

  for (int i = 0; i < 5; i++)
  {
    Address add =  fsm->getFreeBlock();
    cout << "   Block(" << add << ") was get out\n";
    cout << "   Trying to get out Block (" << add << ") again, should fail\n";  
    cout << "   " << (fsm->getFreeBlock(add)?"Sucessfull":"Fail") << "\n";
  }

  cout << "Testing Address getFreeBlocks(unsigned long)\n";
   
  Address add = fsm->getFreeBlocks(30);
  for (int i = 0; i < 30; i++)
  { 
    cout << "    Trying to get out Block(" << add + i << "), should fail\n";
    if (fsm->getFreeBlock(add + i))
      cout << "    Sucessfull to get ou Block(" << add + i <<")\n";
    else
      cout << "    Fail to get ou Block(" << add + i << ")\n";
  }
  
  cout << "end of Address getFreeBlocks(unsigned long) test\n\n";


  cout << "Testing getFreeBlocks(Address, unsigned long)\n";

  cout << "    Trying to get out " << 50 << " blocks from " << 2 << ", should fail\n";
  if (fsm->getFreeBlocks(2, 50))
    cout << "    Sucessfull in get out " << 50 << " blocks from " << 2 << endl;
  else
    cout << "    Fail in get out " << 50 << " blocks from " << 2 << endl;
  
   cout << "    Trying to get out " << 20 << " blocks from " << 98 << ", should fail\n";
  if (fsm->getFreeBlocks(98, 20))
    cout << "    Sucessfull in get out  20 <<  blocks from  98 \n";
  else
    cout << "    Fail in get out 50 blocks from 2 \n";

  cout << "end of getFreeBlocks(Address, unsigned long) test\n\n";


  cout << "Testing releaseBlock(Address)\n";

  for (int i = 0; i < 5; i++)
  {
    Address add = fsm->getFreeBlock();
    cout << "    Get out Block(" << add << ")\n";
    fsm->releaseBlock(add);
    cout << "    Released Block(" << add << ")\n";
    cout << "    Trying to get Block(" << add << "), should sussesfull\n";
    if (fsm->getFreeBlock(add + i))
      cout << "    Sucessfull to get ou Block(" << add  <<")\n";
    else
      cout << "    Fail to get ou Block(" << add  <<")\n";
  }

  cout << "end of releaseBlock(Address) test\n\n";
}
