// EPOS-- ATMega128 UART Mediator Declarations

#ifndef __atmega128_uart_h
#define __atmega128_uart_h

#include "../avr_common/uart.h"

__BEGIN_SYS

class ATMega128_UART: public UART_Common, private AVR_UART
{
public:
    enum {
        FULL                = AVR_UART::FULL,
	LIGHT               = AVR_UART::LIGHT,
	STANDBY             = AVR_UART::STANDBY,
	OFF                 = AVR_UART::OFF
    };
public:
    ATMega128_UART(unsigned int unit = 0) : AVR_UART(9600, 8, 0, 1, unit) {}
    ATMega128_UART(unsigned int baud, unsigned int data_bits, 
		   unsigned int parity, unsigned int stop_bits,
		   unsigned int unit = 0) 
	: AVR_UART(baud, data_bits, parity, stop_bits,unit) {}

    void config(unsigned int baud, unsigned int data_bits,
		unsigned int parity, unsigned int stop_bits) {
	AVR_UART::config(baud, data_bits, parity, stop_bits);
    }
    void config(unsigned int * baud, unsigned int * data_bits,
		unsigned int * parity, unsigned int * stop_bits) {
	AVR_UART::config(*baud, *data_bits, *parity, *stop_bits);
    }

    char get() { while(!rxd_full()); return rxd(); }
    void put(char c) { while(!txd_empty()); txd(c); }

    void loopback(bool flag) { AVR_UART::loopback(flag); }

    char power() { return AVR_UART::power(); }
    void power(char ps) { AVR_UART::power(ps); }
};

__END_SYS

#endif



